/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.AbstractRecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tables.TinkerTables;

public class TinkerStationDamagingRecipe
implements ITinkerStationRecipe {
    private static final ValidatedResult BROKEN = ValidatedResult.failure(TConstruct.makeTranslationKey("recipe", "damaging.broken"), new Object[0]);
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final int damageAmount;

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        if (!inv.getTinkerableStack().m_204117_(TinkerTags.Items.DURABILITY)) {
            return false;
        }
        return IncrementalModifierRecipe.containsOnlyIngredient(inv, this.ingredient);
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationContainer inv) {
        if (ToolDamageUtil.isBroken(inv.getTinkerableStack())) {
            return BROKEN;
        }
        ToolStack tool = ToolStack.copyFrom(inv.getTinkerableStack());
        int maxDamage = IncrementalModifierRecipe.getAvailableAmount(inv, this.ingredient, this.damageAmount);
        ToolDamageUtil.directDamage(tool, maxDamage, null, inv.getTinkerableStack());
        return ValidatedResult.success(tool.createStack());
    }

    @Override
    public int shrinkToolSlotBy() {
        return 1;
    }

    @Override
    public void updateInputs(ItemStack result, IMutableTinkerStationContainer inv, boolean isServer) {
        int damageTaken = ToolStack.from(result).getDamage() - ToolStack.from(inv.getTinkerableStack()).getDamage();
        IncrementalModifierRecipe.updateInputs(inv, this.ingredient, damageTaken, this.damageAmount, ItemStack.f_41583_);
    }

    @Deprecated
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.tinkerStationDamagingSerializer.get();
    }

    public TinkerStationDamagingRecipe(ResourceLocation id, Ingredient ingredient, int damageAmount) {
        this.id = id;
        this.ingredient = ingredient;
        this.damageAmount = damageAmount;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public static class Builder
    extends AbstractRecipeBuilder<Builder> {
        private final Ingredient ingredient;
        private final int damageAmount;

        public void save(Consumer<FinishedRecipe> consumer) {
            ItemStack[] stacks = this.ingredient.m_43908_();
            if (stacks.length == 0) {
                throw new IllegalStateException("Empty ingredient not allowed");
            }
            this.save(consumer, Objects.requireNonNull(stacks[0].m_41720_().getRegistryName()));
        }

        public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
            if (this.ingredient == Ingredient.f_43901_) {
                throw new IllegalStateException("Empty ingredient not allowed");
            }
            ResourceLocation advancementId = this.buildOptionalAdvancement(id, "tinker_station");
            consumer.accept((FinishedRecipe)new Finished(id, advancementId));
        }

        private Builder(Ingredient ingredient, int damageAmount) {
            this.ingredient = ingredient;
            this.damageAmount = damageAmount;
        }

        public static Builder damage(Ingredient ingredient, int damageAmount) {
            return new Builder(ingredient, damageAmount);
        }

        private class Finished
        extends AbstractRecipeBuilder.AbstractFinishedRecipe {
            public Finished(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
                super((AbstractRecipeBuilder)Builder.this, ID, advancementID);
            }

            public void m_7917_(JsonObject json) {
                json.add("ingredient", Builder.this.ingredient.m_43942_());
                json.addProperty("damage_amount", (Number)Builder.this.damageAmount);
            }

            public RecipeSerializer<?> m_6637_() {
                return (RecipeSerializer)TinkerTables.tinkerStationDamagingSerializer.get();
            }
        }
    }

    public static class Serializer
    extends AbstractRecipeSerializer<TinkerStationDamagingRecipe> {
        public TinkerStationDamagingRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"ingredient"));
            int restoreAmount = GsonHelper.m_13927_((JsonObject)json, (String)"damage_amount");
            return new TinkerStationDamagingRecipe(id, ingredient, restoreAmount);
        }

        @Nullable
        public TinkerStationDamagingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int damageAmount = buffer.m_130242_();
            return new TinkerStationDamagingRecipe(id, ingredient, damageAmount);
        }

        public void toNetwork(FriendlyByteBuf buffer, TinkerStationDamagingRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130130_(recipe.damageAmount);
        }
    }
}

